<?php
namespace wcf\system\option\user;
use wcf\data\user\option\UserOption;
use wcf\data\user\User;
use wcf\util\StringUtil;

/**
 * User option output implementation for the output of a Bitbucket.org user profile.
 * 
 * @author	Niklas Mollenhauer
 * @copyright	2013 Niklas Mollenhauer
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	com.woltlab.wcf
 * @subpackage	system.option.user
 * @category	Community Framework
 */
class SteamidUserOptionOutput implements IUserOptionOutput {
	/**
	 * @see	wcf\system\option\user\IUserOptionOutput::getOutput()
	 */
	public function getOutput(User $user, UserOption $option, $value) {
		if (empty($value)) return '';
		$value = trim($value);
		$value = StringUtil::encodeHTML($value);
		return ' <script type="text/javascript" src="'.RELATIVE_WCF_DIR.'steamprofile/ajax/steamprofile.js"></script>
			<div class="steamprofile" title="'.$value.'"></div>';


	}
}
